\name{nih_stroke_scale}
\alias{nih_stroke_scale}
\title{
NIH Stroke Scale (NIHSS)
}
\description{
Calculates the National Institutes of Health Stroke Scale (NIHSS), a systematic assessment tool that provides a quantitative measure of stroke-related neurologic deficit. The scale is widely used to evaluate stroke severity, determine appropriate treatment, and predict patient outcomes.
}
\usage{
nih_stroke_scale(loc_response, loc_questions, loc_commands, gaze, visual_fields,
                 facial_palsy, motor_arm_left, motor_arm_right, motor_leg_left,
                 motor_leg_right, limb_ataxia, sensory, best_language, dysarthria,
                 extinction_inattention)
}
\arguments{
  \item{loc_response}{Numeric (0-3). 1a: Level of Consciousness.}
  \item{loc_questions}{Numeric (0-2). 1b: LOC Questions (Month and Age).}
  \item{loc_commands}{Numeric (0-2). 1c: LOC Commands (Open/close eyes, grip/release hand).}
  \item{gaze}{Numeric (0-2). 2: Best Gaze.}
  \item{visual_fields}{Numeric (0-3). 3: Visual Fields.}
  \item{facial_palsy}{Numeric (0-3). 4: Facial Palsy.}
  \item{motor_arm_left}{Numeric (0-4). 5a: Motor Arm (Left).}
  \item{motor_arm_right}{Numeric (0-4). 5b: Motor Arm (Right).}
  \item{motor_leg_left}{Numeric (0-4). 6a: Motor Leg (Left).}
  \item{motor_leg_right}{Numeric (0-4). 6b: Motor Leg (Right).}
  \item{limb_ataxia}{Numeric (0-2). 7: Limb Ataxia.}
  \item{sensory}{Numeric (0-2). 8: Sensory.}
  \item{best_language}{Numeric (0-3). 9: Best Language.}
  \item{dysarthria}{Numeric (0-2). 10: Dysarthria.}
  \item{extinction_inattention}{Numeric (0-2). 11: Extinction and Inattention (Neglect).}
}
\value{
A list containing:
\item{NIHSS_Score}{The calculated total score (Range 0-42).}
\item{Severity}{Interpretation of stroke severity (Minor, Moderate, Severe).}
}
\references{
Brott T, Adams HP Jr, Olinger CP, et al. Measurements of acute cerebral infarction: a clinical examination scale. Stroke. 1989;20(7):864-870. doi:10.1161/01.str.20.7.864
}
\examples{

# Example 1: Moderate Stroke
# Alert(0), Questions(1), Gaze(1), Face(2), Arm Drift(1), Leg Drift(1), Sensory(1), Mild Aphasia(1)
nih_stroke_scale(0, 1, 0, 1, 0, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0)

# Example 2: Severe Stroke
# Drowsy(1), Gaze(2), Hemianopia(2), Face(3), Arm/Leg Paralysis(4,4), Global Aphasia(3), Neglect(2)
nih_stroke_scale(1, 2, 2, 2, 2, 3, 4, 0, 4, 0, 0, 2, 3, 2, 2)
}
