\name{obesity_surgery_mortality_risk_score}
\alias{obesity_surgery_mortality_risk_score}
\title{
Obesity Surgery Mortality Risk Score (OS-MRS)
}
\description{
Calculates the Obesity Surgery Mortality Risk Score (OS-MRS) to predict 90-day mortality in patients undergoing bariatric surgery. The score assigns 1 point for each of five risk factors: BMI >= 50 kg/m^2, Male sex, Hypertension, known risk factors for DVT/PE (e.g., prior thromboembolism, IVC filter, pulmonary hypertension), and Age >= 45 years.
}
\usage{
obesity_surgery_mortality_risk_score(bmi_ge_50, male_sex, hypertension,
                                     risk_factors_dvt_pe, age_ge_45)
}
\arguments{
  \item{bmi_ge_50}{
Numeric (0 or 1). Is BMI >= 50 kg/m^2? (1 = Yes, +1 point).
}
  \item{male_sex}{
Numeric (0 or 1). Is the patient male? (1 = Yes, +1 point).
}
  \item{hypertension}{
Numeric (0 or 1). Does the patient have hypertension? (1 = Yes, +1 point).
}
  \item{risk_factors_dvt_pe}{
Numeric (0 or 1). Are there known risk factors for pulmonary embolism (e.g., history of DVT/PE, IVC filter, right heart failure)? (1 = Yes, +1 point).
}
  \item{age_ge_45}{
Numeric (0 or 1). Is the patient age >= 45 years? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{OS_MRS_Score}{The calculated total score (Range 0-5).}
\item{Risk_Class}{Classification (Class A: 0-1, Class B: 2-3, Class C: 4-5).}
\item{Est_Mortality_90_Day}{Estimated 90-day postoperative mortality percentage.}
}
\references{
DeMaria EJ, Portenier DS, Wolfe L. Obesity surgery mortality risk score: proposal for a clinically useful score to predict mortality risk in patients undergoing gastric bypass. Surg Obes Relat Dis. 2007;3(2):134-140. doi:10.1016/j.soard.2007.01.005
}
\examples{

# Example 1: High Risk
# BMI 55 (+1), Male (+1), HTN (+1), Prior DVT (+1), Age 50 (+1)
# Score = 5
obesity_surgery_mortality_risk_score(1, 1, 1, 1, 1)

# Example 2: Low Risk
# BMI 40 (0), Female (0), No HTN (0), No PE risk (0), Age 30 (0)
# Score = 0
obesity_surgery_mortality_risk_score(0, 0, 0, 0, 0)
}
