\name{oesil_syncope_score}
\alias{oesil_syncope_score}
\title{
OESIL Score for Syncope
}
\description{
Calculates the OESIL (Osservatorio Epidemiologico sulla Sincope nel Lazio) Score to predict 1-year all-cause mortality in patients presenting to the emergency department with syncope. The score stratifies patients based on four simple clinical variables.
}
\usage{
oesil_syncope_score(age, cv_history, no_prodrome, abnormal_ecg)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 65 years adds 1 point).
}
  \item{cv_history}{
Numeric (0 or 1). History of cardiovascular disease. (1 = Yes, +1 point).
}
  \item{no_prodrome}{
Numeric (0 or 1). Syncope occurring without prodromal symptoms. (1 = Yes, +1 point).
}
  \item{abnormal_ecg}{
Numeric (0 or 1). Abnormal electrocardiogram. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{OESIL_Score}{The calculated score (Range 0-4).}
\item{Est_1_Year_Mortality}{Estimated 1-year mortality risk percentage based on the derivation cohort.}
}
\references{
Colivicchi F, Ammirati F, Melina D, et al. Development and validation of a prognostic scale for the prediction of death following syncope: the OESIL risk score. Eur Heart J. 2003;24(9):811-819. doi:10.1016/s0195-668x(03)00136-9
}
\examples{

# Example 1: High Risk
# 70yo (+1), CV History (+1), Abnormal ECG (+1), Prodrome present (0)
# Score = 3
oesil_syncope_score(70, 1, 0, 1)

# Example 2: Low Risk
# 40yo, No history, No prodrome (+1), Normal ECG
# Score = 1
oesil_syncope_score(40, 0, 1, 0)
}
