\name{overall_neuropathy_limitations_scale}
\alias{overall_neuropathy_limitations_scale}
\title{
Overall Neuropathy Limitations Scale (ONLS)
}
\description{
Calculates the ONLS score to assess disability in patients with immune-mediated peripheral neuropathies (e.g., GBS, CIDP). The scale consists of an Arm Scale (0-5) and a Leg Scale (0-7), summed for a total score of 0-12.
}
\usage{
overall_neuropathy_limitations_scale(arm_symptoms, wash_hair, turn_key,
                                     use_knife, fasten_buttons, leg_symptoms,
                                     walking_status)
}
\arguments{
  \item{arm_symptoms}{
Numeric (0 or 1). Does the patient have symptoms in hands or arms (e.g., tingling, numbness, weakness)? (1 = Yes).
}
  \item{wash_hair}{
Numeric (0, 1, or 2). Ability to wash and brush hair. 0: Normal, 1: Difficulty, 2: Impossible.
}
  \item{turn_key}{
Numeric (0, 1, or 2). Ability to turn a key in a lock. 0: Normal, 1: Difficulty, 2: Impossible.
}
  \item{use_knife}{
Numeric (0, 1, or 2). Ability to use a knife and fork together. 0: Normal, 1: Difficulty, 2: Impossible.
}
  \item{fasten_buttons}{
Numeric (0, 1, or 2). Ability to fasten buttons or zips. 0: Normal, 1: Difficulty, 2: Impossible.
}
  \item{leg_symptoms}{
Numeric (0 or 1). Does the patient have symptoms in legs or feet? (1 = Yes).
}
  \item{walking_status}{
String. Functional status of walking/running.
"normal": No problems (Score 0 if no symptoms, 1 if symptoms).
"symptoms_only": Symptoms present but walks/runs normally (Score 1).
"difficulty_running": Difficulty running or abnormal gait but does not require support (Score 2).
"difficulty_walking": Difficulty walking (gait abnormalities/reduced distance) but independent (Score 3).
"unilateral_support": Uses 1 stick/cane/crutch (Score 4).
"bilateral_support": Uses 2 sticks/crutches or a frame (Score 5).
"wheelchair": Uses a wheelchair (Score 6).
"bedbound": Restricted to bed (Score 7).
}
}
\value{
A list containing:
\item{ONLS_Total_Score}{The calculated total score (Range 0-12).}
\item{Arm_Scale_Score}{The arm subscore (0-5).}
\item{Leg_Scale_Score}{The leg subscore (0-7).}
}
\references{
Graham RC, Hughes RA. A modified peripheral neuropathy scale: the Overall Neuropathy Limitations Scale. J Neurol Neurosurg Psychiatry. 2006;77(8):973-976. doi:10.1136/jnnp.2005.081547
}
\examples{

# Example 1: Mild Disability
# Arm: Symptoms (1), Difficulty buttons (1) -> Score 2
# Leg: Difficulty running -> Score 2
# Total = 4
overall_neuropathy_limitations_scale(1, 0, 0, 0, 1, 1, "difficulty_running")

# Example 2: Severe Disability
# Arm: Cannot wash hair (2), Cannot buttons (2) -> Score 4 (2 impossible)
# Leg: Wheelchair -> Score 6
# Total = 10
overall_neuropathy_limitations_scale(1, 2, 0, 0, 2, 1, "wheelchair")
}
