\name{parkland_burn_formula}
\alias{parkland_burn_formula}
\title{
Parkland Formula for Burn Resuscitation
}
\description{
Calculates the fluid resuscitation requirements for burn patients within the first 24 hours of injury using the Parkland Formula. It determines the total volume of Lactated Ringer's solution required, split into the first 8 hours (50\%) and the subsequent 16 hours (50\%).
}
\usage{
parkland_burn_formula(weight_kg, tbsa_percent)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{tbsa_percent}{
Numeric. Total Body Surface Area burned as a percentage (e.g., enter 20 for 20\%).
}
}
\details{
The formula used is:
\deqn{Total\_Fluid (mL) = 4 \times Weight (kg) \times TBSA (\%)}
Half of this total is administered in the first 8 hours from the time of injury, and the remaining half is administered over the next 16 hours.
}
\value{
A list containing:
\item{Total_Fluid_24h_mL}{Total estimated fluid requirement for the first 24 hours.}
\item{First_8h_Volume_mL}{Volume to be administered in the first 8 hours.}
\item{First_8h_Rate_mL_hr}{Infusion rate for the first 8 hours.}
\item{Next_16h_Volume_mL}{Volume to be administered in the next 16 hours.}
\item{Next_16h_Rate_mL_hr}{Infusion rate for the next 16 hours.}
}
\references{
Baxter CR, Shires T. Physiological response to crystalloid resuscitation of severe burns. Ann N Y Acad Sci. 1968;150(3):874-894. doi:10.1111/j.1749-6632.1968.tb14738.x
}
\examples{

# Example 1: 75kg adult with 20% TBSA burn
# Total = 4 * 75 * 20 = 6000 mL
# First 8h = 3000 mL (375 mL/hr)
parkland_burn_formula(75, 20)

# Example 2: 50kg patient with 40% TBSA burn
# Total = 4 * 50 * 40 = 8000 mL
parkland_burn_formula(50, 40)
}
