\name{pe_sard_bleeding_score}
\alias{pe_sard_bleeding_score}
\title{
PE-SARD Bleeding Risk Score
}
\description{
Calculates the PE-SARD (Pulmonary Embolism - Syncope, Anemia, Renal Dysfunction) Score to predict the risk of early major bleeding in patients with acute pulmonary embolism. The score stratifies patients into Low, Intermediate, and High risk groups.
}
\usage{
pe_sard_bleeding_score(hemoglobin, syncope, egfr)
}
\arguments{
  \item{hemoglobin}{
Numeric. Hemoglobin level in g/dL. (<12 g/dL adds 2.5 points).
}
  \item{syncope}{
Numeric (0 or 1). History of syncope at presentation? (1 = Yes, +1.5 points).
}
  \item{egfr}{
Numeric. Estimated Glomerular Filtration Rate in mL/min/1.73m^2. (<60 mL/min adds 1 point).
}
}
\value{
A list containing:
\item{PE_SARD_Score}{The calculated risk score (Range 0-5).}
\item{Risk_Class}{Risk classification (Low: 0, Intermediate: 1-2.5, High: >2.5).}
\item{Est_Major_Bleeding_Risk}{Estimated probability of early major bleeding.}
}
\references{
Chopard R, Piazza G, Falvo N, et al. An Original Risk Score to Predict Early Major Bleeding in Acute Pulmonary Embolism: The Syncope, Anemia, Renal Dysfunction (PE-SARD) Bleeding Score. Chest. 2021;160(5):1832-1843. doi:10.1016/j.chest.2021.06.048
}
\examples{

# Example 1: High Risk
# Hb 11 (2.5), Syncope (1.5), eGFR 50 (1.0)
# Score = 5
pe_sard_bleeding_score(11, 1, 50)

# Example 2: Low Risk
# Hb 14 (0), No Syncope (0), eGFR 90 (0)
# Score = 0
pe_sard_bleeding_score(14, 0, 90)
}
