\name{pediatric_ett_size}
\alias{pediatric_ett_size}
\title{
Pediatric Endotracheal Tube (ETT) Size Calculator
}
\description{
Calculates the recommended internal diameter (ID) for uncuffed and cuffed endotracheal tubes for pediatric patients based on age. Also estimates the depth of insertion. This function typically uses the Cole formula for children older than 1 year.
}
\usage{
pediatric_ett_size(age_years)
}
\arguments{
  \item{age_years}{
Numeric. Age of the child in years.
}
}
\details{
The standard formulas used for children \eqn{\ge} 1 year are:
\itemize{
  \item \strong{Uncuffed Size (mm ID)}: \eqn{(Age / 4) + 4}
  \item \strong{Cuffed Size (mm ID)}: \eqn{(Age / 4) + 3.5}
  \item \strong{Depth (cm)}: \eqn{(Age / 2) + 12}
}
For infants (< 1 year), fixed sizes (3.5mm uncuffed for <6mo, 4.0mm for 6mo-1yr) are generally recommended.
}
\value{
A list containing:
\item{Uncuffed_ETT_Size_mm}{Recommended internal diameter for an uncuffed tube.}
\item{Cuffed_ETT_Size_mm}{Recommended internal diameter for a cuffed tube.}
\item{Depth_of_Insertion_cm}{Estimated depth of insertion at the lip.}
}
\references{
Cole F. Pediatric formulas for the anesthesiologist. AMA J Dis Child. 1957;94(6):672-673.
Standard PALS Guidelines (AHA).
}
\examples{

# Example 1: 4-year-old child
# Uncuffed: 4/4 + 4 = 5.0 mm
# Cuffed: 4/4 + 3.5 = 4.5 mm
# Depth: 4/2 + 12 = 14 cm
pediatric_ett_size(4)

# Example 2: 8-year-old child
# Uncuffed: 8/4 + 4 = 6.0 mm
# Cuffed: 8/4 + 3.5 = 5.5 mm
# Depth: 8/2 + 12 = 16 cm
pediatric_ett_size(8)
}
