\name{pews_score}
\alias{pews_score}
\title{
Pediatric Early Warning Score (PEWS)
}
\description{
Calculates the Pediatric Early Warning Score (PEWS) based on the Monaghan (Brighton) methodology. This score is used to identify pediatric patients at risk for clinical deterioration. It evaluates three physiological domains (Behavior, Cardiovascular, Respiratory) and includes adjustments for nebulizer use and persistent vomiting.
}
\usage{
pews_score(behavior_score, cardiovascular_score, respiratory_score,
           nebulizer_use, persistent_vomiting)
}
\arguments{
  \item{behavior_score}{
Numeric (0-3).
0: Playing/Appropriate.
1: Sleeping.
2: Irritable.
3: Lethargic/Confused or reduced response to pain.
}
  \item{cardiovascular_score}{
Numeric (0-3).
0: Pink or Capillary Refill (CRT) 1-2s.
1: Pale or CRT 3s.
2: Grey or CRT 4s or Tachycardia of 20 bpm above normal.
3: Grey/Mottled or CRT >=5s or Tachycardia of 30 bpm above normal or Bradycardia.
}
  \item{respiratory_score}{
Numeric (0-3).
0: Within normal parameters, no recession.
1: >10 above normal RR, using accessory muscles, or 30\%+ O2 (or >2L/min).
2: >20 above normal RR, recession, or 40\%+ O2 (or >4L/min).
3: 5 below normal RR with retractions/grunting, or 50\%+ O2 (or >6L/min).
}
  \item{nebulizer_use}{
Numeric (0 or 1). Use of nebulizer treatment (e.g., every 15 minutes). (1 = Yes, +2 points).
}
  \item{persistent_vomiting}{
Numeric (0 or 1). Presence of persistent vomiting following surgery. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{PEWS_Score}{The calculated total PEWS score.}
\item{Risk_Level}{Risk stratification (Low, Low-Intermediate, Intermediate, High).}
\item{Action_Guidance}{Suggested clinical response based on the score.}
}
\references{
Monaghan A. Detecting and managing deterioration in children. Paediatr Nurs. 2005;17(1):32-35. doi:10.7748/paed2005.02.17.1.32.c964
}
\examples{

# Example 1: Stable Patient
# Behavior 0, CV 0, Resp 0, No neb/vomit
pews_score(0, 0, 0, 0, 0)

# Example 2: High Risk Patient
# Lethargic (3), Grey (2), Retractions (2), On Nebs (1)
# Score = 3 + 2 + 2 + 2 = 9
pews_score(3, 2, 2, 1, 0)
}
