\name{phoenix_sepsis_score}
\alias{phoenix_sepsis_score}
\title{
Phoenix Sepsis Score (Pediatric Sepsis Criteria)
}
\description{
Calculates the Phoenix Sepsis Score for pediatric patients (<18 years). This score replaces previous SIRS-based definitions and is used to diagnose sepsis in children with suspected infection. A score of 2 or higher indicates sepsis and is associated with higher in-hospital mortality. The score evaluates four organ systems: Respiratory, Cardiovascular, Coagulation, and Neurologic.
}
\usage{
phoenix_sepsis_score(respiratory_support_type, pao2 = NA, spo2 = NA, fio2 = NA,
                     vasoactive_med_count, lactate_mmol_l, map_below_5th_percentile_age,
                     platelet_count, inr, d_dimer_mg_l, fibrinogen_mg_dl,
                     gcs_score, fixed_pupils)
}
\arguments{
  \item{respiratory_support_type}{
String. Type of respiratory support. Options: "none", "non_invasive" (includes HFNC, NIV, or O2), "invasive" (IMV).
}
  \item{pao2}{
Numeric. PaO2 in mmHg (optional).
}
  \item{spo2}{
Numeric. SpO2 percent (optional).
}
  \item{fio2}{
Numeric. Fraction of inspired oxygen (e.g., 0.21 or 21).
}
  \item{vasoactive_med_count}{
Numeric. Number of vasoactive medications being administered (0, 1, 2, >=3). Includes: dobutamine, dopamine, epinephrine, milrinone, norepinephrine, vasopressin.
}
  \item{lactate_mmol_l}{
Numeric. Serum lactate level in mmol/L.
}
  \item{map_below_5th_percentile_age}{
Numeric (0 or 1). Is the Mean Arterial Pressure (MAP) below the 5th percentile for age? (1 = Yes).
}
  \item{platelet_count}{
Numeric. Platelet count in x10^3/uL.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{d_dimer_mg_l}{
Numeric. D-dimer level in mg/L FEU.
}
  \item{fibrinogen_mg_dl}{
Numeric. Fibrinogen level in mg/dL.
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score.
}
  \item{fixed_pupils}{
Numeric (0 or 1). Are pupils bilaterally fixed? (1 = Yes).
}
}
\value{
A list containing:
\item{Phoenix_Sepsis_Score}{The total calculated score (Range 0-11).}
\item{Subscores}{Individual scores for each organ system.}
\item{Diagnosis}{Interpretation based on the >=2 point threshold.}
}
\references{
Sanchez-Pinto LN, Bennett TD, DeWitt PE, et al. Development and Validation of the Phoenix Criteria for Pediatric Sepsis and Septic Shock. JAMA. 2024;331(8):675-686. doi:10.1001/jama.2024.0196
}
\examples{
# Example 1: Sepsis (Score 2)
# On IMV (1 pt), Normal Labs, GCS 9 (1 pt)
phoenix_sepsis_score("invasive", NA, 98, 30, 0, 1.0, 0, 250, 1.0, 0.5, 200, 9, 0)

# Example 2: Septic Shock (High Score)
# On IMV with severe hypoxemia (3 pts), 2 Vasoactives (4 pts), Plt 50 (1 pt), GCS 15 (0 pts)
# Total = 8
phoenix_sepsis_score("invasive", 60, 90, 100, 2, 4.0, 1, 50, 1.2, 0.5, 200, 15, 0)
}
