\name{prevent_cvd_risk}
\alias{prevent_cvd_risk}
\title{
PREVENT Risk Score for Cardiovascular Disease Events
}
\description{
Calculates the 10-year risk of total cardiovascular disease (CVD) events using the American Heart Association's PREVENT equations. This model includes predictors such as age, sex, cholesterol, blood pressure, diabetes, smoking, eGFR, and BMI, and accounts for current treatments.
}
\usage{
prevent_cvd_risk(age, sex, total_cholesterol, hdl_cholesterol, systolic_bp,
                 diabetes, smoking, egfr, bmi, current_treatment_hypertension,
                 current_treatment_statins)
}
\arguments{
  \item{age}{Numeric. Patient age in years (30-79).}
  \item{sex}{String. "Male" or "Female".}
  \item{total_cholesterol}{Numeric. Total cholesterol (mg/dL or mmol/L).}
  \item{hdl_cholesterol}{Numeric. HDL cholesterol (mg/dL or mmol/L).}
  \item{systolic_bp}{Numeric. Systolic blood pressure (mmHg).}
  \item{diabetes}{Numeric (0 or 1). History of diabetes (1 = Yes).}
  \item{smoking}{Numeric (0 or 1). Current smoker (1 = Yes).}
  \item{egfr}{Numeric. Estimated Glomerular Filtration Rate (mL/min/1.73m^2).}
  \item{bmi}{Numeric. Body Mass Index (kg/m^2).}
  \item{current_treatment_hypertension}{Numeric (0 or 1). Currently treated for hypertension (1 = Yes).}
  \item{current_treatment_statins}{Numeric (0 or 1). Currently taking statins (1 = Yes).}
}
\value{
A list containing:
\item{PREVENT_Risk_Score_10yr}{Estimated 10-year risk of CVD event.}
\item{Risk_Category}{Risk classification (Low, Borderline, Intermediate, High).}
}
\references{
Khan SS, Matsushita K, Sang Y, et al. Development and Validation of the American Heart Association Predicting Risk of Cardiovascular Disease EVENTs (PREVENT) Equations. Circulation. 2023.
}
\examples{
prevent_cvd_risk(
  age = 55, sex = "female", total_cholesterol = 200, hdl_cholesterol = 50,
  systolic_bp = 130, diabetes = 0, smoking = 0, egfr = 90, bmi = 28,
  current_treatment_hypertension = 1, current_treatment_statins = 0
)
}
