\name{psi_port_score}
\alias{psi_port_score}
\title{
Pneumonia Severity Index (PSI/PORT) Score
}
\description{
Calculates the Pneumonia Severity Index (PSI), also known as the PORT Score, to stratify patients with community-acquired pneumonia (CAP) into risk classes (I-V) based on demographics, comorbidities, physical exam findings, and laboratory results. This helps determine the appropriate site of care (outpatient vs. inpatient).
}
\usage{
psi_port_score(age, sex, nursing_home, neoplastic_disease, liver_disease,
               congestive_heart_failure, cerebrovascular_disease, renal_disease,
               altered_mental_status, respiratory_rate, systolic_bp, temperature_c,
               heart_rate, arterial_ph, bun_mg_dl, sodium_mmol_l, glucose_mg_dl,
               hematocrit_percent, pao2_mmhg, pleural_effusion, sao2_percent = NULL)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{nursing_home}{
Numeric (0 or 1). Nursing home resident. (1 = Yes, +10 pts).
}
  \item{neoplastic_disease}{
Numeric (0 or 1). Active neoplastic disease. (1 = Yes, +30 pts).
}
  \item{liver_disease}{
Numeric (0 or 1). History of liver disease. (1 = Yes, +20 pts).
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). History of congestive heart failure. (1 = Yes, +10 pts).
}
  \item{cerebrovascular_disease}{
Numeric (0 or 1). History of cerebrovascular disease. (1 = Yes, +10 pts).
}
  \item{renal_disease}{
Numeric (0 or 1). History of renal disease. (1 = Yes, +10 pts).
}
  \item{altered_mental_status}{
Numeric (0 or 1). Altered mental status (disorientation, stupor, coma). (1 = Yes, +20 pts).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths/min. (>= 30: +20 pts).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 90: +20 pts).
}
  \item{temperature_c}{
Numeric. Temperature in Celsius. (< 35 or >= 40: +15 pts).
}
  \item{heart_rate}{
Numeric. Pulse in beats/min. (>= 125: +10 pts).
}
  \item{arterial_ph}{
Numeric. Arterial pH. (< 7.35: +30 pts).
}
  \item{bun_mg_dl}{
Numeric. Blood Urea Nitrogen in mg/dL. (>= 30: +20 pts).
}
  \item{sodium_mmol_l}{
Numeric. Serum Sodium in mmol/L. (< 130: +20 pts).
}
  \item{glucose_mg_dl}{
Numeric. Glucose in mg/dL. (>= 250: +10 pts).
}
  \item{hematocrit_percent}{
Numeric. Hematocrit percentage. (< 30: +10 pts).
}
  \item{pao2_mmhg}{
Numeric. Arterial partial pressure of oxygen in mmHg. (< 60: +10 pts).
}
  \item{pleural_effusion}{
Numeric (0 or 1). Presence of pleural effusion on imaging. (1 = Yes, +10 pts).
}
  \item{sao2_percent}{
Numeric (Optional). Oxygen saturation percentage. Used if PaO2 is not available. (< 90%: +10 pts).
}
}
\value{
A list containing:
\item{PSI_Score}{The calculated total score.}
\item{Risk_Class}{The risk classification (II-V).}
\item{Mortality_Risk}{Estimated mortality percentage.}
\item{Recommendation}{Suggested site of care.}
}
\references{
Fine MJ, Auble TE, Yealy DM, et al. A prediction rule to identify low-risk patients with community-acquired pneumonia. N Engl J Med. 1997;336(4):243-250. doi:10.1056/NEJM199701233360402
}
\examples{

# Example 1: Low Risk
# 40yo Male, No comorbidities, Normal Vitals/Labs
# Score = 40
psi_port_score(40, "male", 0, 0, 0, 0, 0, 0, 0, 16, 120, 37, 70, 7.4, 15, 140, 90, 40, 90, 0)

# Example 2: High Risk
# 70yo Female (-10), Nursing Home (+10), CHF (+10), RR 32 (+20), BUN 40 (+20)
# Score = 60 + 10 + 10 + 20 + 20 = 120 (Class IV)
psi_port_score(70, "female", 1, 0, 0, 1, 0, 0, 0, 32, 110, 37, 80, 7.4, 40, 140, 100, 40, 80, 0)
}
