\name{radiation_bed_calculator}
\alias{radiation_bed_calculator}
\title{
Radiation Biologically Effective Dose (BED) Calculator
}
\description{
Calculates the Biologically Effective Dose (BED) and the Equivalent Dose in 2 Gy fractions (EQD2) using the linear-quadratic model. This allows for the comparison of different radiation fractionation schedules by normalizing them to a biologically equivalent dose based on tissue sensitivity (alpha/beta ratio).
}
\usage{
radiation_bed_calculator(dose_per_fraction_gy, number_of_fractions, alpha_beta_ratio)
}
\arguments{
  \item{dose_per_fraction_gy}{
Numeric. The radiation dose delivered per fraction in Gray (Gy).
}
  \item{number_of_fractions}{
Numeric. The total number of fractions in the treatment schedule.
}
  \item{alpha_beta_ratio}{
Numeric. The alpha/beta ratio for the specific tissue or tumor type.
Common values:
10 Gy for early-responding tissues and most tumors.
3 Gy for late-responding tissues (e.g., spinal cord, lung).
1.5-3 Gy for prostate cancer.
}
}
\value{
A list containing:
\item{BED_Gy}{The Biologically Effective Dose.}
\item{EQD2_Gy}{The equivalent total dose if delivered in 2 Gy fractions.}
\item{Total_Physical_Dose_Gy}{The total physical dose delivered.}
}
\references{
Fowler JF. The linear-quadratic formula and progress in fractionated radiotherapy. Br J Radiol. 1989;62(740):679-694. doi:10.1259/0007-1285-62-740-679
}
\examples{

# Example 1: Standard Fractionation (Tumor Control)
# 2 Gy x 30 fractions, a/b = 10
# Total = 60 Gy. BED = 60 * (1 + 2/10) = 72 Gy10.
radiation_bed_calculator(2, 30, 10)

# Example 2: SBRT (Tumor Control)
# 20 Gy x 3 fractions, a/b = 10
# Total = 60 Gy. BED = 60 * (1 + 20/10) = 180 Gy10.
radiation_bed_calculator(20, 3, 10)

# Example 3: Late Toxicity Check (Spinal Cord)
# 3 Gy x 10 fractions (Palliative), a/b = 3
# Total = 30 Gy. BED = 30 * (1 + 3/3) = 60 Gy3.
radiation_bed_calculator(3, 10, 3)
}
