\name{rescue_ihca_score}
\alias{rescue_ihca_score}
\title{
RESCUE-IHCA Score for ECPR Survival
}
\description{
Calculates the RESCUE-IHCA score to predict the probability of survival to hospital discharge in patients with in-hospital cardiac arrest (IHCA) who are being considered for Extracorporeal Cardiopulmonary Resuscitation (ECPR). The score stratifies patients based on age, renal history, time of arrest, initial rhythm, and etiology.
}
\usage{
rescue_ihca_score(age, history_renal_insufficiency, time_of_arrest_day,
                  initial_rhythm_shockable, etiology_cardiac)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<60: +6 pts.
60-74: +2 pts.
>=75: 0 pts.
}
  \item{history_renal_insufficiency}{
Numeric (0 or 1). History of renal insufficiency (e.g., creatinine > 1.5 mg/dL or CKD). (1 = Yes, -2 pts).
}
  \item{time_of_arrest_day}{
Numeric (0 or 1). Did the arrest occur during daytime hours (08:00 to 16:59)? (1 = Yes, +2 pts).
}
  \item{initial_rhythm_shockable}{
Numeric (0 or 1). Was the initial rhythm shockable (VF or pVT)? (1 = Yes, +2 pts).
}
  \item{etiology_cardiac}{
Numeric (0 or 1). Is the etiology of the arrest primary cardiac (Medical-Cardiac or Surgical-Cardiac)? (1 = Yes, +4 pts). Note: Non-cardiac etiologies score 0.
}
}
\value{
A list containing:
\item{RESCUE_IHCA_Score}{The calculated score (Range -2 to 16).}
\item{Est_Survival_to_Discharge}{Estimated probability of survival to hospital discharge based on the derivation cohort.}
}
\references{
Schmidt M, Burstein B, Ho EC, et al. Predicting Survival for Patients With In-Hospital Cardiac Arrest Undergoing Extracorporeal Cardiopulmonary Resuscitation: The RESCUE-IHCA Score. JACC: Clinical Electrophysiology. 2020;6(13):1630-1638.
}
\examples{

# Example 1: Good Candidate
# 50yo (+6), No Renal, Day Arrest (+2), VF (+2), Cardiac Cause (+4)
# Score = 14
rescue_ihca_score(50, 0, 1, 1, 1)

# Example 2: Poor Candidate
# 78yo (0), Renal Hx (-2), Night Arrest (0), PEA (0), Non-Cardiac (0)
# Score = -2
rescue_ihca_score(78, 1, 0, 0, 0)
}
