\name{reynolds_risk_score_women}
\alias{reynolds_risk_score_women}
\title{
Reynolds Risk Score for Cardiovascular Risk in Women
}
\description{
Calculates the 10-year cardiovascular disease risk (myocardial infarction, stroke, coronary revascularization, or cardiovascular death) for women. This score improves upon the Framingham Risk Score by incorporating high-sensitivity C-reactive protein (hs-CRP) and family history.
}
\usage{
reynolds_risk_score_women(age_years, systolic_bp_mmhg, total_cholesterol_mg_dl,
                          hdl_cholesterol_mg_dl, hs_crp_mg_l, hba1c_percent,
                          current_smoker, family_history_premature_mi)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years (designed for ages 45 and older).
}
  \item{systolic_bp_mmhg}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{total_cholesterol_mg_dl}{
Numeric. Total cholesterol level in mg/dL.
}
  \item{hdl_cholesterol_mg_dl}{
Numeric. HDL cholesterol level in mg/dL.
}
  \item{hs_crp_mg_l}{
Numeric. High-sensitivity C-reactive protein level in mg/L.
}
  \item{hba1c_percent}{
Numeric. Hemoglobin A1c percentage. (If non-diabetic and unknown, a standard reference value like 5.0 may be used, though clinical measurement is preferred).
}
  \item{current_smoker}{
Numeric (0 or 1). Current cigarette smoker. (1 = Yes).
}
  \item{family_history_premature_mi}{
Numeric (0 or 1). Parental history of myocardial infarction before age 60. (1 = Yes).
}
}
\value{
A list containing:
\item{Reynolds_Risk_Score}{The estimated 10-year risk percentage.}
\item{Risk_Category}{Classification (Low <5\%, Intermediate 5-10\%, High 10-20\%, Very High >=20\%).}
}
\references{
Ridker PM, Buring JE, Rifai N,
Cook NR. Development and validation of improved algorithms for the assessment of global cardiovascular risk in women: the Reynolds Risk Score. JAMA. 2007;297(6):611-619. doi:10.1001/jama.297.6.611
}
\examples{

# Example 1: Low Risk
# 50yo, SBP 120, TC 180, HDL 50, CRP 0.5, A1c 5.0, Non-smoker, No Fam Hx
reynolds_risk_score_women(50, 120, 180, 50, 0.5, 5.0, 0, 0)

# Example 2: High Risk
# 65yo, SBP 150, TC 240, HDL 40, CRP 5.0, A1c 6.5, Smoker, Fam Hx
reynolds_risk_score_women(65, 150, 240, 40, 5.0, 6.5, 1, 1)
}
