\name{rome_iv_child_non_retentive_fecal_incontinence}
\alias{rome_iv_child_non_retentive_fecal_incontinence}
\title{
Rome IV Diagnostic Criteria for Child Non-Retentive Fecal Incontinence
}
\description{
Evaluates the Rome IV criteria for diagnosing non-retentive fecal incontinence in children and adolescents. This functional gastrointestinal disorder involves the passage of feces in inappropriate places without evidence of fecal retention (constipation).
}
\usage{
rome_iv_child_non_retentive_fecal_incontinence(incontinence_frequency,
                                               fecal_retention,
                                               developmental_age_years,
                                               symptom_duration_months,
                                               medical_condition_explained)
}
\arguments{
  \item{incontinence_frequency}{
Numeric. Number of episodes of defecation into places inappropriate to the social context per month. (Must be >= 1).
}
  \item{fecal_retention}{
Numeric (0 or 1). Is there evidence of fecal retention (e.g., retentive posturing, large diameter stools, fecal mass)? (1 = Yes). This excludes the diagnosis (points towards Functional Constipation with Incontinence).
}
  \item{developmental_age_years}{
Numeric. The child's developmental age in years. (Must be >= 4 years).
}
  \item{symptom_duration_months}{
Numeric. Duration of symptoms in months. (Must be >= 1 month).
}
  \item{medical_condition_explained}{
Numeric (0 or 1). Can the symptoms be explained by another medical condition (e.g., inflammatory, anatomic, metabolic, or neoplastic)? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Non-Retentive Fecal Incontinence" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# 1 episode/mo, No retention, Age 6, Duration 2 mo, No other cause
rome_iv_child_non_retentive_fecal_incontinence(1, 0, 6, 2, 0)

# Example 2: Not Met (Retention Present - likely Constipation)
# 4 episodes/mo, Retention Yes, Age 5, Duration 3 mo
rome_iv_child_non_retentive_fecal_incontinence(4, 1, 5, 3, 0)
}
