\name{rome_iv_narcotic_bowel_syndrome}
\alias{rome_iv_narcotic_bowel_syndrome}
\title{
Rome IV Diagnostic Criteria for Narcotic Bowel Syndrome (NBS)
}
\description{
Evaluates the Rome IV criteria for diagnosing Narcotic Bowel Syndrome (NBS) in patients using chronic opioid therapy. NBS is characterized by chronic, worsening, or unremitting abdominal pain associated with escalating opioid doses, distinct from simple Opioid-Induced Constipation (OIC).
}
\usage{
rome_iv_narcotic_bowel_syndrome(chronic_pain_on_opioids,
                                pain_worsens_with_dose_escalation,
                                other_fgid_excluded, symptom_onset_ge_6mo,
                                symptoms_active_last_3mo)
}
\arguments{
  \item{chronic_pain_on_opioids}{
Numeric (0 or 1). Chronic or recurrent abdominal pain is present and has worsened or become unremitting during continued opioid therapy. (1 = Yes).
}
  \item{pain_worsens_with_dose_escalation}{
Numeric (0 or 1). Pain continues or worsens despite increasing opioid dosage. (1 = Yes).
}
  \item{other_fgid_excluded}{
Numeric (0 or 1). Are other functional gastrointestinal disorders (FGIDs) adequately excluded? (1 = Yes).
}
  \item{symptom_onset_ge_6mo}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3mo}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Narcotic Bowel Syndrome (NBS)" or "Criteria Not Met".}
}
\references{
Sikandar A, Kazi U, Khawaja MA. Narcotic Bowel Syndrome: A New Entity in Gastroenterology. J Clin Med Res. 2017;9(3):195-200. doi:10.14740/jocmr2880w
}
\examples{

# Example 1: Diagnosis Met
# Chronic pain, pain worsens, other FGID excluded, chronic duration met
rome_iv_narcotic_bowel_syndrome(1, 1, 1, 1, 1)

# Example 2: Not Met (Pain does not worsen)
# Chronic pain, but pain is stable (0 for pain_worsens_with_dose_escalation)
rome_iv_narcotic_bowel_syndrome(1, 0, 1, 1, 1)
}
