\name{rule_of_nines}
\alias{rule_of_nines}
\title{
Wallace Rule of Nines for Burn Area Assessment
}
\description{
Calculates the Total Body Surface Area (TBSA) percentage involved in burn injuries using the Wallace Rule of Nines. This estimation is crucial for determining fluid resuscitation requirements (e.g., via the Parkland Formula). The function allows inputting the percentage of each anatomical region that is affected (0-100%).
}
\usage{
rule_of_nines(head_percent, left_arm_percent, right_arm_percent,
              anterior_torso_percent, posterior_torso_percent,
              left_leg_percent, right_leg_percent, genitalia_percent,
              patient_type = "adult")
}
\arguments{
  \item{head_percent}{
Numeric (0-100). Percentage of the head/neck surface area that is burned.
}
  \item{left_arm_percent}{
Numeric (0-100). Percentage of the left arm surface area that is burned.
}
  \item{right_arm_percent}{
Numeric (0-100). Percentage of the right arm surface area that is burned.
}
  \item{anterior_torso_percent}{
Numeric (0-100). Percentage of the anterior torso (chest/abdomen) surface area that is burned.
}
  \item{posterior_torso_percent}{
Numeric (0-100). Percentage of the posterior torso (back) surface area that is burned.
}
  \item{left_leg_percent}{
Numeric (0-100). Percentage of the left leg surface area that is burned.
}
  \item{right_leg_percent}{
Numeric (0-100). Percentage of the right leg surface area that is burned.
}
  \item{genitalia_percent}{
Numeric (0-100). Percentage of the genital area that is burned.
}
  \item{patient_type}{
String. "adult" (default) or "child". Adjusts the weights (Head 9% vs 18%, Legs 18% vs 13.5%) to account for pediatric proportions.
}
}
\details{
\strong{Adult Weights:} Head (9\%), Each Arm (9\%), Anterior Torso (18\%), Posterior Torso (18\%), Each Leg (18\%), Genitalia (1\%).
\strong{Child Weights:} Head (18\%), Each Arm (9\%), Anterior Torso (18\%), Posterior Torso (18\%), Each Leg (13.5\%), Genitalia (1\%).
}
\value{
A list containing:
\item{Total_Body_Surface_Area_Burned}{The calculated total burn percentage.}
\item{Inputs}{A summary of the extent of injury entered for each region.}
}
\references{
Wallace AB. The exposure treatment of burns. Lancet. 1951;1(6653):501-504. doi:10.1016/s0140-6736(51)91975-7
}
\examples{

# Example 1: Adult with burns on whole left arm and half of chest
# L Arm (100% burned -> 9 TBSA), R Arm (0%), Ant Torso (50% burned -> 9 TBSA), others 0
# Total TBSA = 9 + 9 = 18%
rule_of_nines(0, 100, 0, 50, 0, 0, 0, 0, "adult")

# Example 2: Child with burns on entire head and right leg
# Head (100% -> 18 TBSA), R Leg (100% -> 13.5 TBSA)
# Total TBSA = 18 + 13.5 = 31.5%
rule_of_nines(100, 0, 0, 0, 0, 0, 100, 0, "child")
}
