\name{scap_pneumonia_score}
\alias{scap_pneumonia_score}
\title{
Severe Community-Acquired Pneumonia (SCAP) Score
}
\description{
Calculates the SCAP score to predict in-hospital mortality and the risk of severe adverse events (SAE) such as ICU admission or need for mechanical ventilation in patients with Community-Acquired Pneumonia. The score ranges from 0 to 59, stratifying patients into four risk classes.
}
\usage{
scap_pneumonia_score(arterial_ph, systolic_bp, respiratory_rate, pao2, fio2,
                     bun, altered_mental_status, age, multilobar_involvement,
                     bun_units = "mg/dL")
}
\arguments{
  \item{arterial_ph}{
Numeric. Arterial pH level. (< 7.30 adds 13 points).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 90 mmHg adds 11 points).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (> 30/min adds 9 points).
}
  \item{pao2}{
Numeric. Partial pressure of oxygen in arterial blood (mmHg).
}
  \item{fio2}{
Numeric. Fraction of inspired oxygen (e.g., 0.21 for room air, or 21). Used to calculate P/F ratio. (P/F < 250 adds 6 points).
}
  \item{bun}{
Numeric. Blood Urea Nitrogen level. (> 30 mg/dL or > 10.7 mmol/L adds 5 points).
}
  \item{altered_mental_status}{
Numeric (0 or 1). Presence of altered mental status (confusion, disorientation). (1 = Yes, +5 points).
}
  \item{age}{
Numeric. Patient age in years. (>= 80 years adds 5 points).
}
  \item{multilobar_involvement}{
Numeric (0 or 1). Presence of multilobar infiltrates on chest X-ray. (1 = Yes, +5 points).
}
  \item{bun_units}{
String. Units for BUN input. Options: "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{SCAP_Score}{The calculated SCAP score.}
\item{Risk_Class}{Risk classification (Low, Moderate, High, Very High).}
\item{Severe_Adverse_Event_Risk}{Estimated risk of SAE (ICU admission, Mechanical Ventilation, or Death).}
\item{In_Hospital_Mortality_Risk}{Estimated risk of in-hospital mortality.}
}
\references{
Espana PP, Capelastegui A, Gorordo I, et al. Development and validation of a clinical prediction rule for severe community-acquired pneumonia. Am J Respir Crit Care Med. 2006;174(11):1249-1256. doi:10.1164/rccm.200602-177OC
}
\examples{

# Example 1: High Risk
# pH 7.25 (+13), SBP 85 (+11), RR 35 (+9), P/F 200 (+6), BUN 40 (+5)
# Score = 13 + 11 + 9 + 6 + 5 = 44
scap_pneumonia_score(7.25, 85, 35, 60, 0.3, 40, 0, 70, 0)

# Example 2: Low Risk
# pH 7.4, SBP 120, RR 20, P/F 300, BUN 15, Alert, Age 50, Unilobar
# Score = 0
scap_pneumonia_score(7.4, 120, 20, 90, 0.21, 15, 0, 50, 0)
}
