\name{sgarbossa_criteria}
\alias{sgarbossa_criteria}
\title{
Sgarbossa's Criteria for MI in Left Bundle Branch Block
}
\description{
Calculates the Sgarbossa Score to diagnose Acute Myocardial Infarction (AMI) in the presence of Left Bundle Branch Block (LBBB) or a paced rhythm. A total score of 3 or greater is reported to have high specificity for diagnosing AMI.
}
\usage{
sgarbossa_criteria(concordant_ste_gt_1mm, concordant_std_v1_v3,
                   discordant_ste_gt_5mm)
}
\arguments{
  \item{concordant_ste_gt_1mm}{
Numeric (0 or 1). ST-segment elevation >= 1 mm concordant with the QRS complex in any lead. (1 = Yes, +5 points).
}
  \item{concordant_std_v1_v3}{
Numeric (0 or 1). ST-segment depression >= 1 mm in lead V1, V2, or V3. (1 = Yes, +3 points).
}
  \item{discordant_ste_gt_5mm}{
Numeric (0 or 1). ST-segment elevation >= 5 mm discordant with the QRS complex (Original criterion). (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{Sgarbossa_Score}{The calculated score (Range 0-10).}
\item{Result}{Interpretation of the score regarding the likelihood of AMI.}
}
\references{
Sgarbossa EB, Pinski SL, Barbagelata A, et al. Electrocardiographic diagnosis of evolving acute myocardial infarction in the presence of left bundle-branch block. GUSTO-1 (Global Utilization of Streptokinase and Tissue Plasminogen Activator for Occluded Coronary Arteries) Investigators. N Engl J Med. 1996;334(8):481-487. doi:10.1056/NEJM199602223340801
}
\examples{

# Example 1: Positive for AMI
# Concordant STE (5 pts)
sgarbossa_criteria(1, 0, 0)

# Example 2: Negative
# Only Discordant STE > 5mm (2 pts)
sgarbossa_criteria(0, 0, 1)
}
