\name{simplified_motor_score}
\alias{simplified_motor_score}
\title{
Simplified Motor Score (SMS)
}
\description{
Calculates the Simplified Motor Score (SMS), a streamlined version of the Glasgow Coma Scale (GCS) that uses only the motor component to predict outcomes in traumatic brain injury. It has been shown to have similar diagnostic accuracy to the full GCS for predicting intubation, neurosurgical intervention, and mortality.
}
\usage{
simplified_motor_score(motor_response)
}
\arguments{
  \item{motor_response}{
Numeric. The patient's best motor response.
2: Obeys commands.
1: Localizes pain.
0: Withdraws to pain or worse (Flexion, Extension, or None).
}
}
\value{
A list containing:
\item{SMS_Score}{The input score (0-2).}
\item{Risk_Classification}{Assessment of TBI severity risk (Low vs. High).}
}
\references{
Gill M, Windemuth R, Steele R, Green SM. A comparison of the Glasgow Coma Scale score to simplified alternative scores for the prediction of traumatic brain injury outcomes. Ann Emerg Med. 2005;45(1):37-42. doi:10.1016/j.annemergmed.2004.07.429
}
\examples{

# Example 1: Patient obeys commands
# Score = 2 (Low Risk)
simplified_motor_score(2)

# Example 2: Patient only localizes pain
# Score = 1 (High Risk)
simplified_motor_score(1)

# Example 3: Decerebrate posturing (Extension)
# Score = 0 (High Risk)
simplified_motor_score(0)
}
