\name{smart_cop_score}
\alias{smart_cop_score}
\title{
SMART-COP Score for Pneumonia Severity
}
\description{
Calculates the SMART-COP score to predict the need for Intensive Respiratory or Vasopressor Support (IRVS) in patients with Community-Acquired Pneumonia (CAP). The score incorporates Systolic BP, Multilobar chest radiography, Albumin, Respiratory rate, Tachycardia, Confusion, Oxygenation, and pH levels, with age-adjusted cutoffs for respiratory rate and oxygenation.
}
\usage{
smart_cop_score(age, systolic_bp, multilobar_cxr, albumin_g_dl,
                respiratory_rate, heart_rate, confusion, arterial_ph,
                pao2_mmhg = NA, spo2_percent = NA, pao2_fio2_ratio = NA)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 90 mmHg adds 2 points).
}
  \item{multilobar_cxr}{
Numeric (0 or 1). Multilobar involvement on chest radiograph. (1 = Yes, +1 point).
}
  \item{albumin_g_dl}{
Numeric. Serum albumin in g/dL. (< 3.5 g/dL adds 1 point).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (Age <= 50: >= 25 adds 1 point; Age > 50: >= 30 adds 1 point).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 125 bpm adds 1 point).
}
  \item{confusion}{
Numeric (0 or 1). New onset confusion. (1 = Yes, +1 point).
}
  \item{arterial_ph}{
Numeric. Arterial pH. (< 7.35 adds 2 points).
}
  \item{pao2_mmhg}{
Numeric (Optional). Arterial partial pressure of oxygen. Used for oxygenation scoring.
}
  \item{spo2_percent}{
Numeric (Optional). Oxygen saturation percentage. Used for oxygenation scoring.
}
  \item{pao2_fio2_ratio}{
Numeric (Optional). PaO2/FiO2 ratio. Used for oxygenation scoring.
Note: Low oxygenation adds 2 points. Thresholds depend on age (<= 50: PaO2 < 70, SpO2 <= 93, P/F < 333; > 50: PaO2 < 60, SpO2 <= 90, P/F < 250).
}
}
\value{
A list containing:
\item{SMART_COP_Score}{The calculated total score (Range 0-11).}
\item{Risk_Category}{Classification (Low, Moderate, High, Very High).}
\item{Prediction}{Estimated risk of needing IRVS.}
}
\references{
Charles PG, Wolfe R, Whitby M, et al. SMART-COP: a tool for predicting the need for intensive respiratory or vasopressor support in community-acquired pneumonia. Clin Infect Dis. 2008;47(3):375-384. doi:10.1086/589754
}
\examples{

# Example 1: High Risk
# 45yo, SBP 85 (+2), Multilobar (+1), Alb 3.0 (+1),
#RR 30 (+1), HR 110 (0), Conf (0), Low O2 (+2), pH 7.30 (+2)
# Score = 9
smart_cop_score(45, 85, 1, 3.0, 30, 110, 0, 7.30, spo2_percent = 88)

# Example 2: Low Risk
# 60yo, SBP 120, Unilobar, Alb 4.0, RR 20, HR 80, Alert, Normal O2/pH
# Score = 0
smart_cop_score(60, 120, 0, 4.0, 20, 80, 0, 7.40, spo2_percent = 98)
}
