\name{stool_osmolar_gap}
\alias{stool_osmolar_gap}
\title{
Stool Osmolar (Osmotic) Gap
}
\description{
Calculates the Stool Osmolar Gap to help differentiate between secretory and osmotic diarrhea. The gap represents the difference between the measured stool osmolality and the estimated stool osmolality contributed by electrolytes (sodium and potassium).
}
\usage{
stool_osmolar_gap(stool_na, stool_k, stool_osmolality = 290)
}
\arguments{
  \item{stool_na}{
Numeric. Stool Sodium concentration in mmol/L (or mEq/L).
}
  \item{stool_k}{
Numeric. Stool Potassium concentration in mmol/L (or mEq/L).
}
  \item{stool_osmolality}{
Numeric. Measured stool osmolality in mOsm/kg. If not measured, 290 mOsm/kg (plasma osmolality) is often used as a surrogate value. Defaults to 290.
}
}
\details{
The formula used is:
\deqn{Gap = Stool Osmolality_{measured} - 2 \times (Stool Na + Stool K)}

Interpretation:
\itemize{
  \item \strong{< 50 mOsm/kg}: Suggests Secretory Diarrhea (e.g., toxins, hormones).
  \item \strong{> 100 mOsm/kg}: Suggests Osmotic Diarrhea (e.g., malabsorption, laxatives).
  \item \strong{50 - 100 mOsm/kg}: Indeterminate.
}
}
\value{
A list containing:
\item{Stool_Osmotic_Gap}{The calculated gap value.}
\item{Interpretation}{Diagnostic classification based on the gap.}
}
\references{
Eherer AJ, Fordtran JS. Fecal osmotic gap and pH in experimental diarrhea of various causes. Gastroenterology. 1992;103(2):545-551. doi:10.1016/0016-5085(92)90845-s
}
\examples{

# Example 1: Osmotic Diarrhea (e.g., Lactose Intolerance)
# Na 30, K 30, Meas Osm 290 -> Gap = 290 - 2(60) = 170
stool_osmolar_gap(30, 30, 290)

# Example 2: Secretory Diarrhea (e.g., Cholera)
# Na 90, K 40, Meas Osm 280 -> Gap = 280 - 2(130) = 20
stool_osmolar_gap(90, 40, 280)
}
