\name{thakar_arf_cardiac_surgery}
\alias{thakar_arf_cardiac_surgery}
\title{
Acute Renal Failure after Cardiac Surgery (Thakar Score)
}
\description{
Calculates the Thakar Score to predict the risk of Acute Renal Failure (ARF) requiring dialysis after open heart surgery. This scoring system uses preoperative variables to stratify patients into risk groups (Low, Moderate, High, Very High).
}
\usage{
thakar_arf_cardiac_surgery(gender, chf, lvef_lt_35, preop_iabp, copd,
                           insulin_dependent_dm, prev_cardiac_surgery,
                           emergency_surgery, surgery_type, creatinine_mg_dl)
}
\arguments{
  \item{gender}{
String. Patient gender ("Male" or "Female"). (Female +1 point).
}
  \item{chf}{
Numeric (0 or 1). Congestive Heart Failure. (1 = Yes, +1 point).
}
  \item{lvef_lt_35}{
Numeric (0 or 1). Left Ventricular Ejection Fraction < 35\%. (1 = Yes, +1 point).
}
  \item{preop_iabp}{
Numeric (0 or 1). Preoperative Intra-Aortic Balloon Pump use. (1 = Yes, +2 points).
}
  \item{copd}{
Numeric (0 or 1). Chronic Obstructive Pulmonary Disease. (1 = Yes, +1 point).
}
  \item{insulin_dependent_dm}{
Numeric (0 or 1). Insulin-requiring Diabetes Mellitus. (1 = Yes, +1 point).
}
  \item{prev_cardiac_surgery}{
Numeric (0 or 1). History of previous cardiac surgery. (1 = Yes, +1 point).
}
  \item{emergency_surgery}{
Numeric (0 or 1). Surgery is emergent (required before next working day). (1 = Yes, +2 points).
}
  \item{surgery_type}{
String. Type of surgery.
"cabg": CABG only (0 points).
"valve": Valve only (+1 point).
"cabg+valve": CABG + Valve (+2 points).
"other": Other cardiac surgery (+2 points).
}
  \item{creatinine_mg_dl}{
Numeric. Preoperative serum creatinine in mg/dL.
< 1.2: 0 points.
1.2 - 2.0: +2 points.
>= 2.1: +5 points.
}
}
\value{
A list containing:
\item{Thakar_Score}{The calculated score (Range 0-17).}
\item{Risk_Group}{Risk classification group.}
\item{Est_Risk_Dialysis_Requirement}{Predicted probability of requiring dialysis.}
}
\references{
Thakar CV, Arrigain S, Worley S, Yared JP, Paganini EP. A clinical score to predict acute renal failure after cardiac surgery. J Am Soc Nephrol. 2005;16(1):162-168. doi:10.1681/ASN.2004040331
}
\examples{

# Example 1: High Risk
# Female, Diabetic (Insulin), Cr 1.5, CABG+Valve
# Score = 1 (F) + 1 (DM) + 2 (Cr) + 2 (Surg) = 6 -> High Risk (7.0\%)
thakar_arf_cardiac_surgery("female", 0, 0, 0, 0, 1, 0, 0, "cabg+valve", 1.5)

# Example 2: Low Risk
# Male, No comorbidities, Cr 0.9, CABG only
# Score = 0 -> Low Risk (0.4\%)
thakar_arf_cardiac_surgery("male", 0, 0, 0, 0, 0, 0, 0, "cabg", 0.9)
}
