\name{timi_risk_index}
\alias{timi_risk_index}
\title{
TIMI Risk Index (TRI) for STEMI
}
\description{
Calculates the TIMI Risk Index for patients with ST-Elevation Myocardial Infarction (STEMI). The index is a continuous variable derived from heart rate, systolic blood pressure, and age, which predicts 30-day mortality. It stratifies patients into five risk groups based on data from the InTIME II trial.
}
\usage{
timi_risk_index(heart_rate, systolic_bp, age)
}
\arguments{
  \item{heart_rate}{
Numeric. Heart rate in beats per minute (bpm).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{age}{
Numeric. Patient age in years.
}
}
\details{
The formula used is:
\deqn{TRI = \frac{Heart Rate \times (Age/10)^2}{Systolic BP}}
Risk Groups (30-day mortality):
\itemize{
  \item Group I (< 12.5): 0.8\%
  \item Group II (12.5 - <17.5): 1.9\%
  \item Group III (17.5 - <22.5): 3.3\%
  \item Group IV (22.5 - 30): 7.3\%
  \item Group V (> 30): 17.4\%
}
}
\value{
A list containing:
\item{TIMI_Risk_Index}{The calculated index score.}
\item{Risk_Group}{The risk quintile (Group I-V).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality percentage.}
}
\references{
Morrow DA, Antman Giugliano RP, et al. A simple bedside risk score for early risk stratification in patients with acute coronary syndromes. Circulation. 2000;102(suppl II):II-203.
Morrow DA, Antman EM, Charlesworth A, et al. TIMI risk score for ST-elevation myocardial infarction: A convenient, bedside, clinical score for risk assessment at presentation: An intravenous nPA for treatment of infarcting myocardium early II trial substudy. Circulation. 2000;102(17):2031-2037. doi:10.1161/01.cir.102.17.2031
}
\examples{

# Example 1: High Risk
# HR 100, SBP 100, Age 75
# TRI = (100 * (7.5^2)) / 100 = 56.25
timi_risk_index(100, 100, 75)

# Example 2: Low Risk
# HR 60, SBP 140, Age 50
# TRI = (60 * (5.0^2)) / 140 = (60 * 25) / 140 = 10.7
timi_risk_index(60, 140, 50)
}
