\name{vaco_index_score}
\alias{vaco_index_score}
\title{
Veterans Health Administration COVID-19 (VACO) Index
}
\description{
Calculates the VACO Index to estimate the 30-day all-cause mortality risk for patients with COVID-19. The index is based on age, sex, and the Charlson Comorbidity Index (CCI) components.
}
\usage{
vaco_index_score(age, sex, myocardial_infarction, congestive_heart_failure,
                 peripheral_vascular_disease, cerebrovascular_disease, dementia,
                 chronic_pulmonary_disease, rheumatologic_disease,
                 peptic_ulcer_disease, liver_disease, diabetes, hemiplegia,
                 renal_disease, cancer, aids)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. "male" or "female".
}
  \item{myocardial_infarction}{
Numeric (0 or 1). History of myocardial infarction.
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). History of congestive heart failure.
}
  \item{peripheral_vascular_disease}{
Numeric (0 or 1). History of peripheral vascular disease.
}
  \item{cerebrovascular_disease}{
Numeric (0 or 1). History of cerebrovascular disease (e.g., stroke or TIA).
}
  \item{dementia}{
Numeric (0 or 1). History of dementia.
}
  \item{chronic_pulmonary_disease}{
Numeric (0 or 1). History of chronic pulmonary disease (e.g., COPD).
}
  \item{rheumatologic_disease}{
Numeric (0 or 1). History of connective tissue disease.
}
  \item{peptic_ulcer_disease}{
Numeric (0 or 1). History of peptic ulcer disease.
}
  \item{liver_disease}{
String. "none", "mild" (chronic hepatitis or cirrhosis without portal hypertension), or "moderate_severe" (cirrhosis with portal hypertension or varices).
}
  \item{diabetes}{
String. "none", "uncomplicated", or "complicated" (end-organ damage).
}
  \item{hemiplegia}{
Numeric (0 or 1). History of hemiplegia or paraplegia.
}
  \item{renal_disease}{
Numeric (0 or 1). Moderate to severe renal disease.
}
  \item{cancer}{
String. "none", "localized" (any tumor, leukemia, lymphoma), or "metastatic" (metastatic solid tumor).
}
  \item{aids}{
Numeric (0 or 1). History of AIDS.
}
}
\value{
A list containing:
\item{VACO_Index_Mortality_30_Day}{The estimated 30-day mortality percentage.}
\item{Inputs}{A summary of the provided inputs and the calculated Charlson Comorbidity Index (CCI) score.}
}
\references{
King JT Jr, Yoon JS, Rentsch CT, et al. Development and validation of a 30-day mortality index based on pre-existing medical administrative data from 13,323 COVID-19 patients: The Veterans Health Administration COVID-19 (VACO) Index. PLoS One. 2020;15(11):e0241825. doi:10.1371/journal.pone.0241825
}
\examples{
# Example 1: High Risk
# 75yo Male, Complicated Diabetes, CHF
vaco_index_score(75, "male", 0, 1, 0, 0, 0, 0, 0, 0, "none", "complicated", 0, 0, "none", 0)

# Example 2: Low Risk
# 40yo Female, No comorbidities
vaco_index_score(40, "female", 0, 0, 0, 0, 0, 0, 0, 0, "none", "none", 0, 0, "none", 0)
}
