\name{vancouver_chest_pain_rule}
\alias{vancouver_chest_pain_rule}
\title{
Vancouver Chest Pain Rule
}
\description{
Applies the Vancouver Chest Pain Rule algorithm to identify patients with chest pain who are at low risk for Acute Coronary Syndrome (ACS) and can be safely discharged. The rule utilizes a decision tree based on ECG findings, history, age, and pain characteristics.
}
\usage{
vancouver_chest_pain_rule(age, prior_acs_nitrate_use, ecg_st_depression,
                          ecg_non_specific_repolarization, troponin_elevated,
                          pain_worse_palpation)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{prior_acs_nitrate_use}{
Numeric (0 or 1). Does the patient have a prior history of ACS or use nitrates? (1 = Yes).
}
  \item{ecg_st_depression}{
Numeric (0 or 1). Presence of ST-segment depression (> 0.5 mm) on ECG? (1 = Yes).
}
  \item{ecg_non_specific_repolarization}{
Numeric (0 or 1). Presence of non-specific repolarization changes on ECG? (1 = Yes).
}
  \item{troponin_elevated}{
Numeric (0 or 1). Is the troponin level elevated (positive) at 0 or 2 hours? (1 = Yes).
}
  \item{pain_worse_palpation}{
Numeric (0 or 1). Does palpation reproduce the pain? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Clinical interpretation (Low Risk vs Not Low Risk).}
\item{Risk_Category}{Categorical risk assessment.}
}
\references{
Cullen L, Greenslade JH, Than M, et al. Validation of the Vancouver Chest Pain Rule using troponin as the only biomarker: a prospective cohort study. Am J Emerg Med. 2014;32(2):114-121. doi:10.1016/j.ajem.2013.10.021
}
\examples{

# Example 1: Low Risk (No Hx, Age < 50)
vancouver_chest_pain_rule(40, 0, 0, 0, 0, 0)

# Example 2: Not Low Risk (Age 60, No reproducible pain)
vancouver_chest_pain_rule(60, 0, 0, 0, 0, 0)

# Example 3: Low Risk (Hx ACS, but pain reproducible)
vancouver_chest_pain_rule(60, 1, 0, 0, 0, 1)
}
