\name{vurx_index}
\alias{vurx_index}
\title{
Vesicoureteral Reflux Index (VURx)
}
\description{
Calculates the VURx Index to predict the likelihood of spontaneous resolution of primary vesicoureteral reflux (VUR) in children. The score is based on the grade of reflux (using the International Reflux Study classification), the timing of reflux during voiding cystourethrogram (VCUG), and the patient's sex.
}
\usage{
vurx_index(vur_grade, reflux_timing, sex)
}
\arguments{
  \item{vur_grade}{
Numeric (1-5). The grade of VUR (1-5).
Grades 1-3: 0 points.
Grade 4: 3 points.
Grade 5: 4 points.
}
  \item{reflux_timing}{
String. The phase of the bladder cycle when reflux occurs.
"voiding": Reflux occurs only during voiding (0 points).
"filling": Reflux occurs during filling (1 point).
}
  \item{sex}{
String. Patient's sex.
"female": 0 points.
"male": 1 point.
}
}
\value{
A list containing:
\item{VURx_Score}{The calculated index score (Range 0-6).}
\item{Interpretation}{Prediction regarding spontaneous resolution success.}
}
\references{
Garcia-Roig M, Ridley DE, McCracken C, et al. Vesicoureteral Reflux Index: a predictive tool for spontaneous resolution of primary vesicoureteral reflux. J Urol. 2011;186(6):2391-2397. doi:10.1016/j.juro.2011.07.109
}
\examples{

# Example 1: High likelihood of resolution
# Grade 2 (0), Voiding (0), Female (0)
# Score = 0
vurx_index(2, "voiding", "female")

# Example 2: Low likelihood of resolution
# Grade 4 (3), Filling (1), Female (0)
# Score = 4
vurx_index(4, "filling", "female")
}
