\name{who_pv_criteria}
\alias{who_pv_criteria}
\title{
WHO Diagnostic Criteria for Polycythemia Vera (2016)
}
\description{
Evaluates the 2016 World Health Organization (WHO) diagnostic criteria for Polycythemia Vera (PV). Diagnosis requires either all three major criteria, or the first two major criteria plus the minor criterion. NOTE: Bone marrow biopsy (Major Criterion 2) may not be required in cases with sustained absolute erythrocytosis (Hb >18.5 g/dL in men or >16.5 g/dL in women) if Major Criterion 3 and the Minor Criterion are present.
}
\usage{
who_pv_criteria(sex, hemoglobin, hematocrit, red_cell_mass_elevated,
                bone_marrow_biopsy, jak2_mutation, serum_epo_low)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). Used to determine hemoglobin/hematocrit thresholds.
}
  \item{hemoglobin}{
Numeric. Hemoglobin level in g/dL.
}
  \item{hematocrit}{
Numeric. Hematocrit percentage (0-100).
}
  \item{red_cell_mass_elevated}{
Numeric (0 or 1). Is the red cell mass > 25\% above the mean normal predicted value? (1 = Yes). Alternative for Major Criterion 1.
}
  \item{bone_marrow_biopsy}{
Numeric (0 or 1). Bone marrow biopsy showing hypercellularity for age with trilineage growth (panmyelosis). (1 = Yes). (Major Criterion 2).
}
  \item{jak2_mutation}{
Numeric (0 or 1). Presence of JAK2 V617F or JAK2 Exon 12 mutation. (1 = Yes). (Major Criterion 3).
}
  \item{serum_epo_low}{
Numeric (0 or 1). Subnormal serum erythropoietin level. (1 = Yes). (Minor Criterion).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Polycythemia Vera" or "Criteria Not Met".}
\item{Criteria_Status}{A list of boolean values indicating which specific criteria were satisfied.}
}
\references{
Arber DA, Orazi A, Hasserjian R, et al. The 2016 revision to the World Health Organization classification of myeloid neoplasms and acute leukemia. Blood. 2016;127(20):2391-2405. doi:10.1182/blood-2016-03-643544
}
\examples{

# Example 1: Diagnosis Met (3 Major Criteria)
# Male, Hb 17.0, Hct 50, Biopsy+, JAK2+
who_pv_criteria("male", 17.0, 50, 0, 1, 1, 0)

# Example 2: Diagnosis Met (2 Major + 1 Minor)
# Female, Hb 16.2, Hct 49, Biopsy+, JAK2-, Low EPO
who_pv_criteria("female", 16.2, 49, 0, 1, 0, 1)
}
