\name{wound_closure_classification}
\alias{wound_closure_classification}
\title{
Wound Closure Classification System
}
\description{
Classifies the type of wound closure based on clinical management. This system categorizes wound healing into Primary Intention (immediate closure), Secondary Intention (healing by granulation), and Tertiary Intention (delayed primary closure).
}
\usage{
wound_closure_classification(wound_status)
}
\arguments{
  \item{wound_status}{
String. The clinical method of wound management.
Options:
"primary" (Immediate approximation of edges),
"secondary" (Left open to heal by granulation),
"tertiary" (Delayed closure after observation).
}
}
\value{
A list containing:
\item{Classification_Type}{The formal classification name.}
\item{Description}{A detailed explanation of the healing process for that classification.}
\item{Examples}{Common clinical scenarios for the selected closure type.}
}
\references{
Boardman JD, et al. Wound Closure. StatPearls [Internet]. Treasure Island (FL): StatPearls Publishing; 2023.
}
\examples{

# Example 1: Surgical Incision
# Primary closure
wound_closure_classification("primary")

# Example 2: Infected Dog Bite
# Delayed closure
wound_closure_classification("tertiary")
}
