% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week_chart.R
\name{week_chart}
\alias{week_chart}
\title{Plot Values on Each Day of a Week}
\usage{
week_chart(wvalue, lgnm = "Value", high = "yellow", low = "green", width = 0.9)
}
\arguments{
\item{wvalue}{A numeric vector having values on each day, starting from
Saturday}

\item{lgnm}{Title of legend}

\item{high}{The color name for the high values. The default is \code{red}}

\item{low}{The color name for the low values. The default is \code{green}.
The color names can be vice versa or other colors, depending on the context.}

\item{width}{The width of bars.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function plots values corresponding to each day on a rose plot.
}
\examples{
set.seed(10)
wtemp <- sample(10:40, 7)
week_chart(wtemp, high = "yellow") + ggplot2::labs(title = "Random Values by Day")
}
\seealso{
\code{\link[=day_chart]{day_chart()}} for plotting values in on a day hours
\code{\link[=year_chart]{year_chart()}} for plotting values on in a year by months
\code{\link[=cyclic_chart]{cyclic_chart()}} for plotting values by arbitrary period
}
