
<!-- README.md is generated from README.Rmd. Please edit that file -->

# cmgnd <img src="man/figures/logo.png" alt="logo" align="right" width="150" style="border: none; float: right;"/>

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/cmgnd)](https://CRAN.R-project.org/package=cmgnd)
[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html)
[![devel
version](https://img.shields.io/badge/devel%20version-0.1.1-blue.svg)](https://github.com/pierdutt/cmgnd)
[![License:
GPL-3](https://img.shields.io/badge/license-GPL--3-forestgreen.svg)](https://cran.r-project.org/web/licenses/GPL-3)
<!-- badges: end -->

## Installation

You can install the development version of cmgnd from
[GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("pierdutt/cmgnd")
```

<div style="text-align: justify;">

**cmgnd** is an R package designed to analyse univariate data with
complex patterns, including asymmetry, multi-modality, and heavy tails.
The package implements the univariate constrained mixture of generalized
normal distributions (cmgnd) model, allowing parameter constraints to be
applied globally or to specific subpartitions of mixture components,
thereby reducing model complexity and improving estimation performance.

</div>

References

Duttilo, P. (2024). Modelling financial returns with mixtures of
generalized normal distributions. PhD Thesis, University “G. d’Annunzio”
of Chieti-Pescara, pp. 1-166,
[arXiv:2411.11847](https://doi.org/10.48550/arXiv.2411.11847)

Duttilo, P. and Gattone, S.A. (2025). Enhancing parameter estimation in
finite mixture of generalized normal distributions, Computational
Statistics, pp. 1-28,
[10.1007/s00180-025-01638-x](https://doi.org/10.1007/s00180-025-01638-x)

Duttilo, P., Gattone, S.A., and Kume A. (2025). Constrained mixtures of
generalized normal distributions, pp. 1-34,
[arXiv:2506.03285](https://doi.org/10.48550/arXiv.2506.03285)
