% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{compute_log_f_gradient_rcpp3}
\alias{compute_log_f_gradient_rcpp3}
\title{Compute the Gradient of the Log-Likelihood Function Proportional Hazards Model (PHM)}
\arguments{
\item{Params}{A numeric vector of parameters.}
}
\value{
A numeric vector representing the gradient of the log-likelihood.
}
\description{
This function computes the gradient of the log-likelihood function for the parametric model (PHM Approach).
}
\examples{
library(cmpp)
set.seed(1984)  
features <- matrix(rnorm(300, 1, 2), nrow = 100, ncol = 3)
delta1 <- sample(c(0, 1), 100, replace = TRUE)
delta2 <- 1 - delta1
x <- rexp(100, rate = 1/10)
Initialize(features, x, delta1, delta2, h = 1e-5)
params <- rep(0.001, 2 * (ncol(features) + 2))
gradient <- compute_log_f_gradient_rcpp3(params)
print(gradient)

}
