% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mon.anomaly.climatology.R
\name{mon.anomaly.climatology}
\alias{mon.anomaly.climatology}
\title{Designed for the CM SAF R Toolbox.}
\usage{
mon.anomaly.climatology(
  var,
  infile,
  outfile,
  climatology_file,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE,
  nc = NULL
)
}
\arguments{
\item{var}{Name of NetCDF variable (character).}

\item{infile}{Filename of input NetCDF file. This may include the directory (character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory (character).}

\item{climatology_file}{Filename of input NetCDF climatology file. This may include the directory (character).}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\description{
This function is a helper function (warming stripes plot, trend plot, time series plot) called by the CM SAF R Toolbox.
}
