% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.codelist.R
\name{as.codelist}
\alias{as.codelist}
\alias{as.codelist.codelist}
\alias{as.codelist.data.frame}
\title{Convert an object to a codelist object}
\usage{
as.codelist(x, ...)

\method{as.codelist}{codelist}(x, ...)

\method{as.codelist}{data.frame}(
  x,
  code = names(x)[1],
  label = names(x)[2],
  description = "description",
  parent = "parent",
  locale = "locale",
  missing = "missing",
  format = c("regular", "wide"),
  locales = NULL,
  locale_sep = "[-_@. ]",
  ...
)
}
\arguments{
\item{x}{data.frame with the code list}

\item{...}{used to pass extra arguments on to other methods.}

\item{code}{the name of the column in \code{x} containing the codes.}

\item{label}{the name of the column in \code{x} containing the labels of the
codes.}

\item{description}{the name of the column in \code{x} containing the labels
of the codes.}

\item{parent}{the name of the column in \code{x} containing the parents of
the codes in case of a hierarchical code list.}

\item{locale}{the name of the column in \code{x} containing the locale of
the corresponding row.}

\item{missing}{the name of the column in \code{x} indicating whether or not
a given code should be treated as missing values.}

\item{format}{the format of data.frame. In case of 'wide', it is assummed that
columns are repeated for each locale. For example there are columns
'label_locale1' and 'label_locale2'. In case of 'regular' there are multiple
rows one for each locale.}

\item{locales}{only used for \code{format = "wide"}. The locales in the data
set.}

\item{locale_sep}{the separator separating the locale from the column name.
This is interpreted as a regular expression (see the 'split' argument of
\code{\link{strsplit}}). The part of the column name until the first
separator is the column name; the remainder the locale name.}
}
\value{
Returns a \code{\link{codelist}} object which is a \code{data.frame} with at
minimum the columns 'code' and 'label' and optionally 'description',
'parent', 'locale' and 'missing'. When \code{x} contains additional columns
these are kept.
}
\description{
Convert an object to a codelist object
}
\details{
When there is no column with the name given by \code{label} in \code{x}, a
new column 'label' is derived containing codes converted to character.
}
\examples{

# Examples below show the same codelist in both regular and wide format
dta <- data.frame(codes = c(1:3, 1:3), 
  labels = c(letters[1:3], LETTERS[1:3]), 
  locale = c("en", "en", "en", "nl" ,"nl" ,"nl"))
as.codelist(dta, format = "regular")

dta <- data.frame(codes = 1:3, labels_en = letters[1:3], 
  labels_nl = LETTERS[1:3])
as.codelist(dta, format = "wide")

}
\seealso{
\code{\link{codelist}} for a description of the \code{codelist} object.
}
