% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelcast.R
\name{levelcast}
\alias{levelcast}
\title{Recode codes to a higher level in a hierarchy}
\usage{
levelcast(
  x,
  level,
  codelist = attr(x, "codelist"),
  over_level = c("error", "missing", "ignore"),
  filter_codelist = TRUE
)
}
\arguments{
\item{x}{vector of codes to record. This can be an object of type
\code{\link{code}}.}

\item{level}{level to which to cast the codes.}

\item{codelist}{the \code{\link{codelist}} for the codes. This code list
should be hierarchical will the cast have effect.}

\item{over_level}{how to handle codes that are in a higher level than the
level that is cast to. The default 'error' will generate an error; 'missing'
will result in missing values for those codes; 'ignore' will keep these
codes.}

\item{filter_codelist}{if \code{TRUE} codes with a level lower than the lever
cast to will be removed from the code list that is returned with the result.}
}
\value{
A vector with the same length as \code{x}.
}
\description{
Recode codes to a higher level in a hierarchy
}
\details{
When handling codes that are in a higher level than the level that is cast
to, codes that are missing values are ignored as these are often in the
highest level.
}
\examples{
cl <- codelist(
    codes = c("A", "B", "A1", "A2", "B1", "B2", "A1.1", "B2.2", "X"),
    parent = c(NA, NA, "A", "A", "B", "B", "A1", "B2", NA),
    missing = c(0, 0, 0, 0, 0, 0, 0, 0, 1)
  )
x <- code(c("A1.1", "A1", "A2", "B2.2", "B2.2", NA, "B2", "X"), cl)
levelcast(x, 1)
levelcast(x, 2, over_level = "ignore")
levelcast(x, 0)

}
