% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colf_nls.R
\name{colf_nls}
\alias{colf_nls}
\title{Non linear Least Squares Optimization on a Linear Objective Function}
\usage{
colf_nls(formula, data, start = NULL, trace = FALSE, control = NULL,
  na.action = c("na.omit", "na.fail", "na.exclude"), lower = -Inf,
  upper = Inf, ...)
}
\arguments{
\item{formula}{The formula. This has the same syntax and supports the same features as the 
formula in \code{lm}. See examples.}

\item{data}{A data frame containing the data of the variables in the formula.}

\item{start}{An atomic vector of same length as the number of parameters. If not provided a 
cheap guess will be made. If categorical variables are included these need to be takent into 
consideration as number of categories minus one. See examples and details.}

\item{trace}{Logical. Defaults to FALSE. Set to TRUE if you want the intermediate progress to be 
reported}

\item{control}{an optional list of control settings. See nls.control for the names of 
the settable control values and their effect.}

\item{na.action}{A function which indicates what should happen if NAs are present in the data
set. Defaults to options('na.action'). na.fail, or na.exclude can be used.}

\item{lower}{Lower bounds of the parameters (atomic vector). If a single number, this will be 
applied to all parameters. Defaults to -Inf (unconstrained).}

\item{upper}{Upper bounds of the parameters (atomic vector). If a single number, this will be 
applied to all parameters. Defaults to Inf (unconstrained).}

\item{...}{Other arguments passed on to optimiser}
}
\value{
Same as nls
}
\description{
Non linear least squares optimization using the port algorithm on a linear objective function.
}
\details{
\code{colf_nls} uses nls, in an attempt to find the minimum of the residual sum of squares. 
The algorithm is applied on a linear objective function.

The function provides an easy way to apply the optimizer on a linear objective function in a 
similar way to \code{lm}.

start, lower and upper, if provided, can be either an atomic vector which has the same length as
the number of parameters or a single number which will be replicated to match the length of the 
parameters. If categorical variables exist in the function these will be dummified. Out of one
categorical variable, n - 1 will be created where n is the total number of categories in the 
variable. This needs to be taken into account when providing an atomic vector for start, lower or
upper. Also, as with \code{lm} an intercept will be added which also needs to be taken into 
account.
}
\examples{
#no constraints
colf_nls(mpg ~ cyl + disp, mtcars)

#no intercept
colf_nls(mpg ~ 0 + cyl + disp, mtcars)

#including categorical variables. These will be dummified.
colf_nls(Sepal.Length ~ Sepal.Width + Species, iris)

#lower boundary will be replicated for all parameters 
colf_nls(Sepal.Length ~ Sepal.Width + Species, iris, lower = 0.5)

#species is categorical and contains 3 categories, thus we need to specify 4 lower bounds:
#the first one for the intercept.
#the second one for Sepal.Width 
#the two next for the dummy variables constructed from Species. 
colf_nls(Sepal.Length ~ Sepal.Width + Species, iris, lower = rep(0.5, 4))

}
\seealso{
\link[stats]{nls}, \link[stats]{nls.control}
}

