% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_auto.R
\name{f_auto}
\alias{f_auto}
\title{Automatic selection of predictor scoring method}
\usage{
f_auto(df = NULL, response = NULL, predictors = NULL, quiet = FALSE, ...)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{response}{(optional, character string) Name of a response variable in \code{df}. Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
function name
}
\description{
Internal function to select a proper \code{f_...()} function to compute preference order depending on the types of the response variable and the predictors. The selection criteria is available as a dataframe generated by \code{\link[=f_auto_rules]{f_auto_rules()}}.
}
\examples{
data(
  vi_smol,
  vi_predictors_numeric,
  vi_predictors_categorical,
  vi_predictors
  )

f_auto(
  df = vi_smol,
  response = "vi_numeric",
  predictors = vi_predictors_numeric
  )

f_auto(
  df = vi_smol,
  response = "vi_binomial",
  predictors = vi_predictors_numeric
  )

f_auto(
  df = vi_smol,
  response = "vi_categorical",
  predictors = vi_predictors_categorical
  )


}
\seealso{
Other preference_order_tools: 
\code{\link{f_auto_rules}()},
\code{\link{f_functions}()}
}
\concept{preference_order_tools}
