% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_categorical_rf.R
\name{f_categorical_rf}
\alias{f_categorical_rf}
\title{Cramer's V of Categorical Random Forest predictions vs. observations}
\usage{
f_categorical_rf(df, ...)
}
\arguments{
\item{df}{(required, dataframe) with columns:
\itemize{
\item \code{x}: (numeric) numeric, character, or factor predictor.
\item \code{y} (numeric) character or factor response.
}}

\item{...}{(optional) Accepts the arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and Inf) for cross validation.}
}
\value{
numeric or numeric vector: Cramer's V
}
\description{
Fits a univariate random forest model \code{y ~ x} with the character or factor response \code{y} and the numeric, character or factor predictor \code{x} using \code{ranger::ranger()} and returns the Cramer's V (see \code{\link[=cor_cramer]{cor_cramer()}}) between the observed responses and the model predictions. Cases are weighted with \code{\link[=case_weights]{case_weights()}} to prevent issues arising from class imbalance.

Cases are weighted with \code{\link[=case_weights]{case_weights()}} to prevent issues arising from class imbalance.

Supports cross-validation via the arguments arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and \code{n}) introduced via ellipsis (\code{...}). See \code{\link[=preference_order]{preference_order()}} for further details.
}
\examples{
data(vi_smol)

df <- data.frame(
  y = vi_smol[["vi_factor"]],
  x = vi_smol[["soil_type"]]
)

#no cross-validation
f_categorical_rf(df = df)

#cross-validation
f_categorical_rf(
  df = df,
  cv_training_fraction = 0.5,
  cv_iterations = 10
  )

#numeric predictor
df <- data.frame(
  y = vi_smol[["vi_categorical"]],
  x = vi_smol[["swi_max"]]
)

f_categorical_rf(df = df)

}
\seealso{
Other preference_order_functions: 
\code{\link{f_binomial_gam}()},
\code{\link{f_binomial_glm}()},
\code{\link{f_binomial_rf}()},
\code{\link{f_count_gam}()},
\code{\link{f_count_glm}()},
\code{\link{f_count_rf}()},
\code{\link{f_numeric_gam}()},
\code{\link{f_numeric_glm}()},
\code{\link{f_numeric_rf}()},
\code{\link{preference_order}()}
}
\concept{preference_order_functions}
