% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_function_name.R
\name{validate_arg_function_name}
\alias{validate_arg_function_name}
\title{Build hierarchical function names for messages}
\usage{
validate_arg_function_name(default_name = NULL, function_name = NULL, ...)
}
\arguments{
\item{default_name}{(optional, character) Name of the calling function. Default: NULL}

\item{function_name}{(optional, character) Name of the parent function. Default: NULL}

\item{...}{(optional) Used to pass \code{function_name} within these functions that don't have this argument.}
}
\value{
character
}
\description{
Concatenates parent and child function names for a better message, warning, and error tracing.
}
\examples{
x <- validate_arg_function_name(
  default_name = "child_function",
  function_name = "parent_function"
)

message(x)
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
