% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcTWC.R
\name{calcTWC}
\alias{calcTWC}
\alias{calctwc}
\alias{windchill}
\alias{TWC}
\alias{twc}
\title{Windchill temperature (TWC)}
\usage{
calcTWC(v,ta)

windchill(v,ta)
}
\arguments{
\item{v}{a numeric value presenting meteorological wind speed (at 10 m) in [km/h]}

\item{ta}{a numeric value presenting ambient air temperature in [degree C]}
}
\value{
returns (twc) Wind chill temperature in [Degree C]
}
\description{
Function to calculate windchill temperature, TWC, in Degrees.
}
\details{
The function returns the temperature that considers the cooling effect on a localized skin segment.
}
\note{
The authors disclaim all obligations and liabilities for damages arising from the use or attempted use of the information, including, but not limited to, direct, indirect, special and consequential damages, and attorneys' and experts' fees and court costs. Any use of the information will be at the risk of the user.
}
\examples{
calcTWC(6.8,-25)
}
\references{
ISO 11079, 2007-12-15, ERGONOMICS OF THE THERMAL ENVIRONMENT - DETERMINATION AND INTERPRETATION OF COLD STRESS WHEN USING REQUIRED CLOTHING INSULATION (IREQ) AND LOCAL COOLING EFFECTS
}
\author{
Developed by Ingvar Holmer and Hakan O. Nilsson, 1990 in java and transferred to R by Shoaib Sarwar. Further contribution by Marcel Schweiker.
}
