% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_grouped_similarity.R
\name{get_grouped_similarity}
\alias{get_grouped_similarity}
\title{Get averaged similarity scores between target word(s) and one or two vectors of candidate words.}
\usage{
get_grouped_similarity(
  x,
  target,
  first_vec,
  second_vec,
  pre_trained,
  transform_matrix,
  group_var,
  window = window,
  norm = "l2",
  remove_punct = FALSE,
  remove_symbols = FALSE,
  remove_numbers = FALSE,
  remove_separators = FALSE,
  valuetype = "fixed",
  hard_cut = FALSE,
  case_insensitive = TRUE
)
}
\arguments{
\item{x}{a (quanteda) \code{corpus} object}

\item{target}{(character) vector of words}

\item{first_vec}{(character) vector of words}

\item{second_vec}{(character) vector of words}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings,
usually trained on the same corpus as that used for \code{x}.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{group_var}{(character) variable name in corpus object defining grouping variable}

\item{window}{(numeric) - defines the size of a context (words around the target)}

\item{norm}{(character) - "l2" for l2 normalized cosine similarity and "none" for dot product}

\item{remove_punct}{(logical) - if \code{TRUE} remove all characters in the Unicode
"Punctuation" \verb{[P]} class}

\item{remove_symbols}{(logical) - if \code{TRUE} remove all characters in the Unicode
"Symbol" \verb{[S]} class}

\item{remove_numbers}{(logical) - if \code{TRUE} remove tokens that consist only of
numbers, but not words that start with digits, e.g. \verb{2day}}

\item{remove_separators}{(logical) - if \code{TRUE} remove separators and separator
characters (Unicode "Separator" \verb{[Z]} and "Control" \verb{[C]} categories)}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching}

\item{hard_cut}{(logical) - if TRUE then a context must have \code{window} x 2 tokens,
if FALSE it can have \code{window} x 2 or fewer (e.g. if a doc begins with a target word,
then context will have \code{window} tokens rather than \code{window} x 2)}

\item{case_insensitive}{(logical) - if \code{TRUE}, ignore case when matching a
target patter}
}
\value{
a \code{data.frame} with the following columns:
\describe{
\item{\code{group}}{ the grouping variable specified for the analysis}
\item{\code{val}}{(numeric) cosine similarity scores}
}
}
\description{
Get similarity scores between a target word or words and a comparison vector
of one candidate word or words. When two vectors of candidate words are
provided (\code{second_vec} is not \code{NULL}), the function calculates the cosine
similarity between a composite index of the two vectors. This is
operationalized as the mean similarity of the target word to the first
vector of terms plus negative one multiplied by the mean similarity to the
second vector of terms.
}
\examples{
quanteda::docvars(cr_sample_corpus, 'year') <- rep(2011:2014, each = 50)
cos_simsdf <- get_grouped_similarity(cr_sample_corpus,
                                    group_var = "year",
                                    target = "immigration",
                                    first_vec = c("left", "lefty"),
                                    second_vec = c("right", "rightwinger"),
                                    pre_trained = cr_glove_subset,
                                    transform_matrix = cr_transform,
                                    window = 12L,
                                    norm = "l2")
}
