% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_fasta.R
\name{find_fasta}
\alias{find_fasta}
\title{Find fasta files present in a folder}
\usage{
find_fasta(dir, pattern = "\\\\.fa$|\\\\.fas$|\\\\.fasta$", exclude)
}
\arguments{
\item{dir}{Path to the directory which should be examined. If not provided,
the current working directory (as returned by \code{\link{getwd}}) is
used.}

\item{pattern}{Regular expression used by \code{\link{list.files}} to detect
the fasta files. The default is to list all files ending in ".fa",
".fas", and ".fasta".}

\item{exclude}{Optional regular expression used to exclude some filenames
from the list of detected files.}
}
\value{
A vector with the full paths to the found files.
}
\description{
Find fasta files present in a folder
}
\examples{
# Get the directory containing the package example files
dir <- system.file("extdata", package = "concatipede")
# List the fasta files containing in that directory
find_fasta(dir)
# Exclude some files
find_fasta(dir, exclude = "COI")

}
