% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_markdown_for_publications.R
\name{generate_markdown_for_publications}
\alias{generate_markdown_for_publications}
\title{Generate markdown for publications}
\usage{
generate_markdown_for_publications(publication)
}
\arguments{
\item{publication}{A \code{condensr} publication object. If a link is available (i.e.
\code{!is.na(publication$link)}), then a hyperlink will be inserted.}
}
\value{
No return value, function will output text directly into markdown
document using \code{cat}.
}
\description{
Generate markdown block for \code{codensr} publications.
}
\examples{
example_publication <- publication(
    title = "Joe's Blogging Paper",
    related_staff = c("joe-bloggs"),
    link = NA,
    citation = "Bloggs, J., Bloggy, Y. (2019),
         The power of blogging, Australian Journal of Bloggs, 43: 149-155.",
    date = as.Date("2019-01-01")
)
generate_markdown_for_publications(example_publication)

}
