% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myfunction.R
\name{conformal_pvalues}
\alias{conformal_pvalues}
\title{Conformal P-values Calculation}
\usage{
conformal_pvalues(train_data, calib_data, test_data, target_col, method)
}
\arguments{
\item{train_data}{A data frame containing the training data with the target variable.}

\item{calib_data}{A data frame containing the calibration data with the target variable.}

\item{test_data}{A data frame containing the test data.}

\item{target_col}{The name of the target variable column.}

\item{method}{A character string specifying the classification method to use.
Options are 'naiveBayes', 'svm', and 'glm'.

This function trains a Naive Bayes classifier, computes non-conformity scores on the calibration data and test data, and calculates conformal p-values of both classes "0" and "1" using the conformal prediction for a binary classification problem.}
}
\value{
A matrix containing p-values for each test case and class.
}
\description{
This function calculates conformal p-values based of binary class labels for test data.
}
\examples{
\donttest{
# Create dummy train_data, calib_data, and test_data
train_data <- data.frame(
  x1 = as.numeric(rnorm(50, 1, 2)),
  x2 = as.numeric(rnorm(50, 2.5, 3)),
  target = as.factor(rbinom(50, 1, 0.5))
)
calib_data <- data.frame(
  x1 = as.numeric(rnorm(50, 1, 2)),
  x2 = as.numeric(rnorm(50, 2.5, 3)),
  target = as.factor(rbinom(50, 1, 0.5))
)
test_data <- data.frame(
  x1 = as.numeric(rnorm(50, 1, 2)),
  x2 = as.numeric(rnorm(50, 2.5, 3))
)
p_values <- conformal_pvalues(train_data, calib_data, test_data, target="target", method="svm")
}
}
