% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{simplef}
\alias{simplef}
\title{simplef}
\usage{
simplef(theta, item, model, D)
}
\arguments{
\item{theta}{a scalar value of theta.}

\item{item}{an item design matrix that is of size response categories (k) by three. The three columns are:
\itemize{
\item column one is scoring values, usually from 0 to k.
\item column two is the delta dot parameter repeated k times (the average difficulty of the item)
\item column three is the tau (step) parameter where for k = 1, tau = 0, and for k >= 2,
subsequent entries are deviations from delta dot.
\item column four is the discrimination paramter ("a")
}}

\item{model}{a string, either "muraki"  or "conquest" (default) (see 10.1177/0146621697211001).
This tells downstream functions what parameterisation has been used for the model and helps with
plotting and other outputs.}

\item{D}{a number, giving the scaling constant. Default is 1 (logistic metric).
Other common values are D = 1.7 (to give the normal ogive metric)}
}
\value{
a double - the expected score at theta.
}
\description{
returns expected score at a given value of theta.
}
\examples{
myTheta <- 0
myDelta <- 1.5
k <- 3
a <- 1
itemParamX <- seq(0, k-1, 1)
itemParamD <- rep(myDelta, k)
itemParamT <- c(0, -0.5, 0.5)
itemParamA <- rep(a, k)
itemParam <- cbind(itemParamX, itemParamD, itemParamT, itemParamA)
colnames(itemParam)<- c("x", "d", "t", "a")
myExpect <- simplef(myTheta, itemParam)
}
\keyword{internal}
