% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jeffreys_CI_1x2.R
\name{Jeffreys_CI_1x2}
\alias{Jeffreys_CI_1x2}
\title{Jeffreys confidence interval for the binomial probability}
\usage{
Jeffreys_CI_1x2(X, n, alpha = 0.05)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
Jeffreys confidence interval for the binomial probability

Described in Chapter 2 "The 1x2 Table and the Binomial Distribution"
}
\examples{
Jeffreys_CI_1x2(singh_2010["1st", "X"], singh_2010["1st", "n"])
Jeffreys_CI_1x2(singh_2010["2nd", "X"], singh_2010["2nd", "n"])
Jeffreys_CI_1x2(singh_2010["3rd", "X"], singh_2010["3rd", "n"])
with(singh_2010["4th", ], Jeffreys_CI_1x2(X, n)) # alternative syntax
Jeffreys_CI_1x2(ligarden_2010["X"], ligarden_2010["n"])
}
