% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_successive_differences.R
\name{backward_difference_code}
\alias{backward_difference_code}
\title{Use backward difference coding}
\usage{
backward_difference_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Compares the mean of level k to level k-1. Differs in direction from
\link[contrastable]{forward_difference_code}, so be careful to pick the
right function.  See also \link[MASS]{contr.sdif}.
}
\details{
Example interpretation for a 4 level factor:
\itemize{
\item Intercept = Grand mean (mean of the means of each level)
\item grp1 = mean(grp2) - mean(grp1)
\item grp2 = mean(grp3) - mean(grp2)
\item grp3 = mean(grp4) - mean(grp3)
}
}
\examples{
mydf <- data.frame(
  grp = gl(4,5),
  resp = c(seq(1, 5), seq(5, 9), seq(10, 14), seq(15, 19))
)

mydf <- set_contrasts(mydf, grp ~ backward_difference_code)

lm(resp ~ grp, data = mydf)
}
