% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_conv_msteps.R
\name{gamma_conv_msteps}
\alias{gamma_conv_msteps}
\title{Gamma convergence iterated on several years in pairs}
\usage{
gamma_conv_msteps(rawDat, startTime, endTime, timeName = "time")
}
\arguments{
\item{rawDat}{the tibble made by  times and countries.}

\item{startTime}{the first year  to  consider, included.}

\item{endTime}{the last year to consider, included.}

\item{timeName}{the name of the variable that contains time information.}
}
\value{
dataset of gamma values  (indicated as KIt in Eurofound 2018 paper).
}
\description{
Given a dataframe (tibble) of sorted times by countries indicator,
the gamma convergence is calculated between pairs of subsequent years.
A time index is required. Missing values are not allowed.
}
\examples{

# Example 1
# Dataframe in the format time by countries:
require(tibble)
myTB  <- tibble::tribble(
~time, ~UK, ~DE, ~IT,
 1988,   1201, 868, 578,
 1989,   1150, 978, 682,
 1990,   998,  1250, 332,
 1991,  1600,  1350, 802
 )
 resGammaST <- gamma_conv_msteps(myTB,startTime = 1988,endTime=1991, timeName = "time")

# Example 2
# Gamma convergence iterated for several pairs of years for the emp_20_64_MS Eurofound dataset
data("emp_20_64_MS")
# check name of the time variable
names(emp_20_64_MS)
resGammaST2<-gamma_conv_msteps(emp_20_64_MS,startTime=2002,endTime=2006, timeName = "time")
resGammaST3<-gamma_conv_msteps(emp_20_64_MS,startTime=2002,endTime=2018, timeName = "time")
resGammaST4<-gamma_conv_msteps(emp_20_64_MS,startTime=2007,endTime=2012, timeName = "time")

}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
