% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_estimation.R
\name{estimate_DFM}
\alias{estimate_DFM}
\title{Estimate Dynamic Factor Model with VAR dynamics}
\usage{
estimate_DFM(
  factors_data,
  p = 2,
  compute_oos = TRUE,
  hc_type = "HC3",
  verbose = TRUE
)
}
\arguments{
\item{factors_data}{List containing PLS-extracted factor scores (\code{scores_X},
\code{scores_Y}) and related objects.}

\item{p}{Integer. VAR lag order. If \code{NULL}, selected automatically. Default is 2.}

\item{compute_oos}{Logical. Should out-of-sample diagnostics be computed? Default is TRUE.}

\item{hc_type}{Character string. Heteroskedasticity-consistent SE type. Default is "HC3".}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{var_fit}}{Fitted VAR model on combined factors.}
\item{\code{p_used}}{VAR lag order used.}
\item{\code{robust_se}}{Matrices of robust standard errors.}
\item{\code{diagnostics}}{List of diagnostic tests (stability, serial correlation).}
\item{\code{oos_metrics}}{Out-of-sample forecast evaluation (if requested).}
}
}
\description{
Estimates a Dynamic Factor Model by extracting factors via PLS and modeling
their dynamics with a Vector Autoregression. Includes automatic lag selection,
robust inference, and optional out-of-sample evaluation.
}
\details{
This function models the joint dynamics of X and Y factors using a VAR.
It performs stability checks, tests for serial correlation, computes robust
standard errors, and optionally evaluates forecast performance out-of-sample.
}
