% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence.R
\name{topic_sim_seq}
\alias{topic_sim_seq}
\title{Calculate topic similarity sequence for a single dyad}
\usage{
topic_sim_seq(conversation, method = "lda", num_topics = 2, window_size = 3)
}
\arguments{
\item{conversation}{A data frame representing the conversation}

\item{method}{A character string specifying the method to use: "lda" or "lsa"}

\item{num_topics}{An integer specifying the number of topics to use in the model}

\item{window_size}{An integer specifying the size of the sliding window}
}
\value{
A list containing the sequence of similarities and the average similarity
}
\description{
This function calculates topic similarity over a sequence of conversation exchanges within a single dyad.
}
\examples{
conversation <- data.frame(
  processed_text = c("The cat sat on the mat", "The dog chased the cat",
                     "The mat was comfortable", "The cat liked the mat")
)
result <- topic_sim_seq(conversation, method = "lda", num_topics = 2, window_size = 2)
print(result)
}
